IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[hips].[HealthProviderIndividualHpiiHistoryInsert]') AND type in (N'P', N'PC'))
BEGIN
	DROP PROCEDURE [hips].[HealthProviderIndividualHpiiHistoryInsert]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO

-- =============================================

-- Create date:   07/10/2015
-- Description:   Insert history for Health Provider Individual HPII
-- 05/02/2016 Allow null HPI-I values to be logged in the hpii history table
-- =============================================

CREATE PROCEDURE [hips].[HealthProviderIndividualHpiiHistoryInsert]
(
	@HealthProviderIndividualId INT,
	@HealthProviderOrganisationNetworkId INT,
	@Hpii VARCHAR(16) = NULL,
	@HpiiStatusId INT,	
	@UserModified VARCHAR(256) 	
)
AS
BEGIN

	SET NOCOUNT ON
	
	DECLARE @ErrorCode INT = 0,		
			@HealthProviderIndividualHpiiHistoryId INT,
			@CurrentDate DATETIME = GETDATE()
	

	INSERT INTO [hips].[HealthProviderIndividualHpiiHistory]
	(	HealthProviderIndividualId,
		HealthProviderOrganisationNetworkId,
		Hpii,
		HpiiStatusId,		
		DateCreated,
		UserCreated,
		DateModified,
		UserModified
	)
	VALUES
	(	@HealthProviderIndividualId,
        @HealthProviderOrganisationNetworkId,
        @Hpii,
        @HpiiStatusId,
        @CurrentDate,
		@UserModified,
		@CurrentDate,
		@UserModified
	)
	
	SELECT	@ErrorCode = @@ERROR,
			@HealthProviderIndividualHpiiHistoryId = SCOPE_IDENTITY()
			
	IF @ErrorCode = 0
	BEGIN
		SELECT HpiiHistoryId,
			   HealthProviderIndividualId,
			   HealthProviderOrganisationNetworkId,
			   Hpii,
			   HpiiStatusId,
			   DateCreated,
			   UserCreated,
			   DateModified,
			   UserModified
		FROM [hips].HealthProviderIndividualHpiiHistory
		WHERE HpiiHistoryId = @HealthProviderIndividualHpiiHistoryId
	END
	
	RETURN(@ErrorCode)
	
END
GO
GRANT EXEC ON [hips].[HealthProviderIndividualHpiiHistoryInsert] TO RunStoredProcedure
GO
